/*******************************************************************************
* Device      : AD18F08
* Author      :
* Version     : V0.0.1
* Date        : 20230516
* Description : 演示进入PWOFF低功耗模式，并通过复位引脚PB3产生复位进行唤醒的功能。
*               进入PWOFF模式之前，IO口PB2进行一定次数翻转，进入PWOFF模式睡眠后，IO口PB2停止翻转；
*				通过给复位引脚PB3输入低电平产生复位唤醒PWOFF后，将复位引脚PB3输入高电平取消复位状态后IO口PB2会再次进行翻转。
********************************************************************************/
#include "AD18F08.h"
#include <stdio.h>

/*********************************************************************************************
* 常用配置字功能说明：
*
* _FINTOSC_DIV1     :  内部时钟分频选择
* _DBG_OFF          :  禁用DEBUG模式（使能后DEBUG 口不能做普通IO用）
* _LVREN_OFF        :  LVR使能位
* _LVR24V           :  选择LVR电压为2.4V
* _FLASH_CP1_OFF    :  1K~2K*16 FLASH保护位
* _FLASH_CP0_OFF    :  0~1K*16 FLASH保护位
* _IDIS_OFF	     	:  模拟IO打开，数据读取控制位
* _CKSUM_OFF        :  使能程序校验
* _CBP_OFF			:  代码保护选择位
* _RESETE_ON        :  使能外部复位
* _RSEL_LOW		    :  端口上下拉电阻选择
* _STV_ON		    :  堆栈溢出复位使能位
* _PSUT_2		    :  上电复位时间选择位
* _FCPU_4T          :  选择指令周期为4T模式
* _WDTE_OFF         :  看门狗使能位
* _TWDT_000         :  看门狗溢出时间选择位
* _OSCM_HIRC_16M    :  选择内部高速时钟16MHz
* _MTPDIS_OFF       ： SWD模式下读FLASH和EEPROM控位
* _ADCSP_ON			:  ADC采集速度选择位
*
* 注意：1.配置字若无特别需求请勿修改；
*       2.其他配置字及相应功能见Datasheet及头文件；
*
************************************************************************************************/

__CONFIG(1,_FINTOSC_DIV1_1L     & _DBG_OFF_1L       & _LVREN_OFF_1L     & _LVR24V_1L                                                  );
__CONFIG(2,_FLASH_CP1_OFF_2L    & _FLASH_CP0_OFF_2L & _IDIS_OFF_2L      & _CKSUM_OFF_2L  & _CBP_OFF_2L   & _RESETE_ON_2L & _RSEL_LOW_2L & _STV_ON_2L  );
__CONFIG(3,_PSUT_2_3L           & _FCPU_4T_3L       & _WDTE_OFF_3L      & _TWDT_100_3L                                                );
__CONFIG(4,_OSCM_HIRC_16M_4L    & _MTPDIS_OFF_4L    & _ADCSP_ON_4L                                                                                     );

#define SLEEP_PWIDLE() 		SMCR = 0X01; SLEEP();NOP();NOP()
#define SLEEP_PWSAVE() 		SMCR = 0X03; SLEEP();NOP();NOP()
#define SLEEP_DEEPPWSAVE()  SMCR = 0X05; SLEEP();NOP();NOP()
#define SLEEP_PWOFF() 		SMCR = 0X07; SLEEP();NOP();NOP()

void main(void)
{
	unsigned char i;

	PBPU = 0XF7;//PB3打开上拉

	TRISB3=1;//PB3设为输入模式
	TRISB2=0;//PB2设为输出模式

	while(1)
	{
		for(i=0;i<100;i++)
		{
			PB2=~PB2;
			__delay_us(5000);
		}
		PB2=0;

		//SLEEP_PWIDLE();
		//SLEEP_PWSAVE();
		//SLEEP_DEEPPWSAVE();
		SLEEP_PWOFF();	//进入pwoff低功耗模式
	}
}

//高优先级中断服务函数

void interrupt ISR_h (void)
{
//进入中断后系统自动关闭中断



}

//低优先级中断服务函数

void interrupt low_priority ISR_l (void)
{


}

